/*
 * Copyright Staffan Gimåker 2008-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_GET_POSITION_HH_INCLUDED
#define PEEKABOT_GET_POSITION_HH_INCLUDED


#include <exception>
#include "../Types.hh"
#include "../Action.hh"


namespace peekabot
{
    /**
     * \brief This action fetches the position of an object and returns
     * it to the source proxy - it is not intended for usage by components other
     * than the proxy.
     */
    class GetPosition : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        /**
         * \brief Create a new get position action.
         *
         * \param request_id The get-requests request ID.
         * \param target The ID of the object whose position is being 
         * requested.
         * \param world_coords If true the position in world coordinates 
         * will be feched, if false local coordinates will be used.
         */
        GetPosition(
            uint32_t request_id, 
            ObjectID target, 
            CoordinateSystem coord_sys) throw();

        virtual ~GetPosition() throw();

        virtual Action *clone() const;

        virtual void execute(
            ServerExecutionContext *context) 
            const throw(std::exception);

    private:
        GetPosition() throw();

        GetPosition(const GetPosition &x) throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        uint32_t m_request_id;

        ObjectID m_target;

        CoordinateSystem m_coord_sys;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 37


#endif // PEEKABOT_GET_POSITION_HH_INCLUDED
