/*
 * Copyright Staffan Gimåker 2007-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_GET_TRANSFORMATION_HH_INCLUDED
#define PEEKABOT_GET_TRANSFORMATION_HH_INCLUDED


#include "../Types.hh"
#include "../Action.hh"

#include <boost/cstdint.hpp>


namespace peekabot
{
    /**
     * \brief This action fetches the transformation of an object and returns
     * it to the source proxy - it is not intended for usage by components other
     * than the proxy.
     */
    class GetTransformation : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        /**
         * \brief Create a new get transformation action.
         *
         * \param request_id The get-requests request ID.
         * \param target The ID of the object whose transformation is being 
         * requested.
         * \param world_coords If true the transformation in world coordinates 
         * will be feched, if false local coordinates will be used.
         */
        GetTransformation(
            boost::uint32_t request_id,
            ObjectID target,
            CoordinateSystem coord_sys) throw();

        virtual ~GetTransformation() throw();

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

    private:
        GetTransformation() throw();

        GetTransformation(const GetTransformation &x) throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        boost::uint32_t m_request_id;

        ObjectID m_target;

        CoordinateSystem m_coord_sys;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 31


#endif // PEEKABOT_GET_TRANSFORMATION_HH_INCLUDED
