/*
 * Copyright Staffan Gimåker 2006-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include <stdexcept>
#include "LoadScene.hh"

#ifdef __PEEKABOT_SERVER
#  include "../ServerExecutionContext.hh"
#  include "../SceneObject.hh"
#  include "../Path.hh"
#endif


using namespace peekabot;


LoadScene::LoadScene() throw()
{
}


LoadScene::LoadScene(
    ObjectID parent_id,
    const std::string &filename,
    NameConflictPolicy conflict_policy)
    throw()
    : m_parent_id(parent_id),
      m_filename(filename),
      m_conflict_policy(conflict_policy)
{
}


LoadScene::~LoadScene() throw()
{
}


Action *LoadScene::clone() const
{
    return new LoadScene(m_parent_id, m_filename, m_conflict_policy);
}


void LoadScene::execute(ServerExecutionContext *context) const
{
#ifdef __PEEKABOT_SERVER
    SceneObject *parent = context->get_object(m_parent_id);

    if( !parent )
        throw std::runtime_error(
            "Failed to load scene file - destination object not found.");

    std::vector<SceneObject *> objs = context->load_scene(
        context->make_data_path(m_filename));

    for( size_t i = 0; i < objs.size(); ++i )
        parent->attach(objs[i], m_conflict_policy);
#endif
}


void LoadScene::save(SerializationInterface &ar) const
{
    ar << m_parent_id << m_filename << m_conflict_policy;
}


void LoadScene::load(DeserializationInterface &ar)
{
    ar >> m_parent_id >> m_filename >> m_conflict_policy;
}
