/*
 * Copyright Staffan Gimåker 2006-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_LOAD_SCENE_HH_INCLUDED
#define PEEKABOT_LOAD_SCENE_HH_INCLUDED


#include <string>
#include <exception>
#include "../Types.hh"
#include "../Action.hh"


namespace peekabot
{
    class LoadScene : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        LoadScene(
            ObjectID parent_id, 
            const std::string &filename,
            NameConflictPolicy conflict_policy) 
            throw();

        virtual ~LoadScene() throw();

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

    private:
        LoadScene() throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        ObjectID  m_parent_id;
        std::string m_filename;
        NameConflictPolicy m_conflict_policy;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 23


#endif // PEEKABOT_LOAD_SCENE_HH_INCLUDED
