/*
 * Copyright Staffan Gimåker 2006-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_MINI_BUNDLE_HH_INCLUDED
#define PEEKABOT_MINI_BUNDLE_HH_INCLUDED


#include <vector>
#include <boost/shared_ptr.hpp>

#include "../Types.hh"
#include "../Action.hh"


namespace peekabot
{
    class MiniBundle : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        MiniBundle();

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

        virtual void execute(ClientExecutionContext *context) const;

        void add_action(Action *action);

        void add_action(boost::shared_ptr<Action> action);

    private:
        MiniBundle(const MiniBundle &bundle);

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        std::vector<boost::shared_ptr<Action> > m_actions;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 116


#endif // PEEKABOT_MINI_BUNDLE_HH_INCLUDED
