/*
 * Copyright Staffan Gimåker 2006-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_NOOP_HH_INCLUDED
#define PEEKABOT_NOOP_HH_INCLUDED


#include "../Types.hh"
#include "../Action.hh"


namespace peekabot
{
    /**
     * \brief An action that does <em>absolutely nothing</em>.
     *
     * Why is it useful? It's used to implement syncing (see \c Proxy::sync()),
     * in a very tidy (and efficient!) manner.
     */
    class NoOp : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        NoOp() throw() {}

        virtual ~NoOp() throw() {}

        virtual Action *clone() const { return new NoOp(); }

        virtual void execute(
            ServerExecutionContext *context)
            const throw() {}

        virtual void execute(
            ClientExecutionContext *context)
            const throw() {}

    protected:
        void save(SerializationInterface &ar) const {}

        void load(DeserializationInterface &ar) {}
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 24


#endif // PEEKABOT_NOOP_HH_INCLUDED
