/*
 * Copyright Staffan Gimåker 2006-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include <stdexcept>
#include "RegisterPseudonym.hh"

#ifdef __PEEKABOT_SERVER
#  include "../ServerExecutionContext.hh"
#  include "../SceneObject.hh"
#endif


using namespace peekabot;


RegisterPseudonym::RegisterPseudonym() throw()
{
}


RegisterPseudonym::RegisterPseudonym(
    const std::string &path, ObjectID id) throw()
    : m_parent_id((ObjectID)-1),
      m_path(path),
      m_pseudonym_id(id)
{
}


RegisterPseudonym::RegisterPseudonym(
    ObjectID parent_id, const std::string &name, ObjectID id) throw()
    : m_parent_id(parent_id),
      m_path(name),
      m_pseudonym_id(id)
{
}


RegisterPseudonym::~RegisterPseudonym() throw()
{
}


Action *RegisterPseudonym::clone() const
{
    return new RegisterPseudonym(m_parent_id, m_path, m_pseudonym_id);
}


void RegisterPseudonym::execute(ServerExecutionContext *context) const
{
#ifdef __PEEKABOT_SERVER
    SceneObject *obj;

    if( m_parent_id == (ObjectID)-1 )
        obj = context->get_object(m_path);
    else
    {
        SceneObject *parent = context->get_object(m_parent_id);

        if( !parent )
            throw std::runtime_error(
                "Register pseudonym failed - parent not found");

        obj = parent->get_child(m_path);
    }

    if( !obj )
        throw std::runtime_error(
            "Register pseudonym failed - object not found (" + m_path + ")");

    context->register_pseudonym(obj->get_object_id(), m_pseudonym_id);
#endif
}


void RegisterPseudonym::save(SerializationInterface &ar) const
{
    ar << m_parent_id << m_path << m_pseudonym_id;
}

void RegisterPseudonym::load(DeserializationInterface &ar)
{
    ar >> m_parent_id >> m_path >> m_pseudonym_id;
}
