/*
 * Copyright Staffan Gimåker 2006-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_REGISTER_PSEUDONYM_HH_INCLUDED
#define PEEKABOT_REGISTER_PSEUDONYM_HH_INCLUDED


#include <string>

#include "../Types.hh"
#include "../Action.hh"


namespace peekabot
{
    class RegisterPseudonym : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        RegisterPseudonym(const std::string &path, ObjectID id) throw();

        RegisterPseudonym(
            ObjectID parent_id, const std::string &name, ObjectID id) throw();

        virtual ~RegisterPseudonym() throw();

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

    private:
        RegisterPseudonym() throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        ObjectID m_parent_id;
        std::string m_path;
        ObjectID m_pseudonym_id;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 2


#endif // PEEKABOT_REGISTER_PSEUDONYM_HH_INCLUDED
