/*
 * Copyright Staffan Gimåker 2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_ROTATE_HH_INCLUDED
#define PEEKABOT_ROTATE_HH_INCLUDED


#include "../Types.hh"
#include "../Action.hh"


namespace peekabot
{
    /**
     * \brief Rotate an object about an arbitrary pivot using an arbitrary
     * rotational axis.
     */
    class Rotate : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        Rotate(
            ObjectID target, float rad,
            float axis_x, float axis_y, float axis_z,
            CoordinateSystem axis_coord_sys,
            float pivot_x, float pivot_y, float pivot_z,
            CoordinateSystem pivot_coord_sys) throw();

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

    private:
        Rotate() throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        ObjectID m_target;
        float m_rad;

        float m_axis_x, m_axis_y, m_axis_z;
        CoordinateSystem m_axis_coord_sys;

        float m_pivot_x, m_pivot_y, m_pivot_z;
        CoordinateSystem m_pivot_coord_sys;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 103


#endif // PEEKABOT_ROTATE_HH_INCLUDED
