/*
 * Copyright Staffan Gimåker 2007-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_SET_COLORED_VERTICES_HH_INCLUDED
#define PEEKABOT_SET_COLORED_VERTICES_HH_INCLUDED


#include <vector>
#include <Eigen/Core>
#include <boost/cstdint.hpp>

#include "../Types.hh"
#include "../Action.hh"


namespace peekabot
{
    class SetColoredVertices : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        SetColoredVertices(
            ObjectID target,
            const std::vector<Eigen::Vector3f> &vertices,
            const std::vector<boost::uint8_t> &colors,
            bool add_to_existing = false) throw();

        virtual ~SetColoredVertices() throw();

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

    private:
        SetColoredVertices() throw();

        SetColoredVertices(const SetColoredVertices &x) throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        ObjectID m_target;
        std::vector<Eigen::Vector3f> m_vertices;
        std::vector<boost::uint8_t> m_colors;
        bool m_add_to_existing;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 117


#endif // PEEKABOT_SET_COLORED_VERTICES_HH_INCLUDED
