/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include <cassert>
#include <stdexcept>
#include <boost/foreach.hpp>

#include "SetIndices.hh"
#include "../serialization/Containers.hh"

#ifdef __PEEKABOT_SERVER
#  include "../ServerExecutionContext.hh"
#  include "../TriMesh.hh"
#endif


using namespace peekabot;


SetIndices::SetIndices() throw()
{
}


SetIndices::SetIndices(
    ObjectID target,
    const std::vector<boost::uint32_t> &indices,
    bool add_to_existing) throw()
    : m_target(target),
      m_indices(indices),
      m_add_to_existing(add_to_existing)
{
}


SetIndices::SetIndices(const SetIndices &x) throw()
    : m_target(x.m_target),
      m_indices(x.m_indices),
      m_add_to_existing(x.m_add_to_existing)
{
}


SetIndices::~SetIndices() throw()
{
}


Action *SetIndices::clone() const
{
    return new SetIndices(*this);
}


void SetIndices::execute(ServerExecutionContext *context) const
{
#ifdef __PEEKABOT_SERVER
    SceneObject *obj = context->get_object(m_target);

    if( !obj )
        throw std::runtime_error("Object not found");

    TriMesh *tri_mesh = dynamic_cast<TriMesh *>(obj);

    if( !tri_mesh )
        throw std::runtime_error(
            "Target object is not a tri-mesh");

    if( m_add_to_existing )
        tri_mesh->add_indices(m_indices);
    else
        tri_mesh->set_indices(m_indices);
#endif
}


void SetIndices::save(SerializationInterface &ar) const
{
    ar << m_target << m_indices << m_add_to_existing;
}

void SetIndices::load(DeserializationInterface &ar)
{
    ar >> m_target >> m_indices >> m_add_to_existing;
}
