/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_SET_INDICES_HH_INCLUDED
#define PEEKABOT_SET_INDICES_HH_INCLUDED


#include "../Types.hh"
#include "../Action.hh"

#include <vector>
#include <boost/cstdint.hpp>


namespace peekabot
{
    class SetIndices : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        SetIndices(
            ObjectID target,
            const std::vector<boost::uint32_t> &indices,
            bool add_to_existing = false) throw();

        virtual ~SetIndices() throw();

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

    private:
        SetIndices() throw();

        SetIndices(const SetIndices &x) throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        ObjectID m_target;
        std::vector<boost::uint32_t> m_indices;
        bool m_add_to_existing;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 107


#endif // PEEKABOT_SET_INDICES_HH_INCLUDED
