/*
 * Copyright Staffan Gimåker 2008-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include <cassert>
#include <cmath>
#include <cstring>
#include <stdexcept>

#include "SetOccupancyGrid2DCells.hh"
#include "../serialization/Containers.hh"
#include "../serialization/Pair.hh"
#include "../serialization/Eigen.hh"

#ifdef __PEEKABOT_SERVER
#  include "../ServerExecutionContext.hh"
#  include "../OccupancyGrid2D.hh"
#endif


using namespace peekabot;


SetOccupancyGrid2DCells::SetOccupancyGrid2DCells() throw()
{
}


SetOccupancyGrid2DCells::SetOccupancyGrid2DCells(
    ObjectID target,
    const std::vector<std::pair<Eigen::Vector2f, float> > &cells) throw()
    : m_target(target),
      m_cells(cells)
{
}


SetOccupancyGrid2DCells::SetOccupancyGrid2DCells(const SetOccupancyGrid2DCells &x) throw()
    : m_target(x.m_target),
      m_cells(x.m_cells)
{
}


SetOccupancyGrid2DCells::~SetOccupancyGrid2DCells() throw()
{
}


Action *SetOccupancyGrid2DCells::clone() const
{
    return new SetOccupancyGrid2DCells(*this);
}


void SetOccupancyGrid2DCells::execute(ServerExecutionContext *context) const
{
#ifdef __PEEKABOT_SERVER
    SceneObject *obj = context->get_object(m_target);

    if( !obj )
        throw std::runtime_error(
            "Failed to set occupancy grid (2D) cells: object not found");

    OccupancyGrid2D *og = dynamic_cast<OccupancyGrid2D *>(obj);

    if( !og )
        throw std::runtime_error(
            "Failed to set occupancy grid (2D) cells: "
            "target is of non-vertex object type");

    og->set_cells(m_cells);
#endif
}


void SetOccupancyGrid2DCells::save(SerializationInterface &ar) const
{
    ar << m_target << m_cells;
}


void SetOccupancyGrid2DCells::load(DeserializationInterface &ar)
{
    ar >> m_target >> m_cells;
}
