/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include <cassert>
#include <cmath>
#include <cstring>
#include <stdexcept>

#include "SetOccupancyGrid3DCells.hh"
#include "../serialization/Containers.hh"
#include "../serialization/Pair.hh"
#include "../serialization/Eigen.hh"

#ifdef __PEEKABOT_SERVER
#  include "../ServerExecutionContext.hh"
#  include "../OccupancyGrid3D.hh"
#endif


using namespace peekabot;


SetOccupancyGrid3DCells::SetOccupancyGrid3DCells() throw()
{
}


SetOccupancyGrid3DCells::SetOccupancyGrid3DCells(
    ObjectID target,
    const std::vector<std::pair<Eigen::Vector3f, float> > &cells) throw()
    : m_target(target),
      m_cells(cells)
{
}


SetOccupancyGrid3DCells::SetOccupancyGrid3DCells(const SetOccupancyGrid3DCells &x) throw()
    : m_target(x.m_target),
      m_cells(x.m_cells)
{
}


SetOccupancyGrid3DCells::~SetOccupancyGrid3DCells() throw()
{
}


Action *SetOccupancyGrid3DCells::clone() const
{
    return new SetOccupancyGrid3DCells(*this);
}


void SetOccupancyGrid3DCells::execute(ServerExecutionContext *context) const
{
#ifdef __PEEKABOT_SERVER
    SceneObject *obj = context->get_object(m_target);

    if( !obj )
        throw std::runtime_error(
            "Failed to set occupancy grid (3D) cells: object not found");

    OccupancyGrid3D *og = dynamic_cast<OccupancyGrid3D *>(obj);

    if( !og )
        throw std::runtime_error(
            "Failed to set occupancy grid (3D) cells: "
            "target is of non-vertex object type");

    og->set_cells(m_cells);
#endif
}


void SetOccupancyGrid3DCells::save(SerializationInterface &ar) const
{
    ar << m_target << m_cells;
}


void SetOccupancyGrid3DCells::load(DeserializationInterface &ar)
{
    ar >> m_target >> m_cells;
}
