/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_SET_OCCUPANCY_GRID_3D_CELLS_HH_INCLUDED
#define PEEKABOT_SET_OCCUPANCY_GRID_3D_CELLS_HH_INCLUDED


#include <vector>
#include <utility>
#include <Eigen/Core>

#include "../Types.hh"
#include "../Action.hh"


namespace peekabot
{
    /**
     * \brief This action is used to set the coordinates of a  object.
     *
     * \sa \c Object
     */
    class SetOccupancyGrid3DCells : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        SetOccupancyGrid3DCells(
            ObjectID target,
            const std::vector<std::pair<Eigen::Vector3f, float> > &cells)
            throw();

        virtual ~SetOccupancyGrid3DCells() throw();

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

    private:
        SetOccupancyGrid3DCells() throw();

        SetOccupancyGrid3DCells(const SetOccupancyGrid3DCells &x) throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        ObjectID m_target;

        std::vector<std::pair<Eigen::Vector3f, float> > m_cells;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 112


#endif // PEEKABOT_SET_OCCUPANCY_GRID_3D_CELLS_HH_INCLUDED
