/*
 * Copyright Staffan Gimåker 2007-2009.
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_SET_POSITION_HH_INCLUDED
#define PEEKABOT_SET_POSITION_HH_INCLUDED


#include "../Types.hh"
#include "../Action.hh"

#include <Eigen/Core>


namespace peekabot
{
    /**
     * \brief Sets the position of an object without affecting its orientation.
     */
    class SetPosition : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        SetPosition(
            ObjectID target,
            const Eigen::Vector3f &pos,
            CoordinateSystem coord_sys) throw();

        virtual ~SetPosition() throw();

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

    private:
        SetPosition() throw();

        SetPosition(const SetPosition &action) throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        ObjectID m_target;

        Eigen::Vector3f m_pos;

        CoordinateSystem m_coord_sys;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 35


#endif // PEEKABOT_SET_POSITION_HH_INCLUDED
