/*
 * Copyright Staffan Gimåker 2009-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_SET_PROP_HH_INCLUDED
#define PEEKABOT_SET_PROP_HH_INCLUDED


#include "../Types.hh"
#include "../Action.hh"
#include "../Any.hh"


namespace peekabot
{
    class SceneObject;

    class SetProp : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        SetProp(ObjectID target, PropKey key,
                const Any &val, bool recursive = false)
            : m_target(target), m_key(key),
              m_val(val), m_recursive(recursive) {}

        template<typename T>
        SetProp(ObjectID target, PropKey key,
                const T &val, bool recursive = false)
            : m_target(target), m_key(key),
              m_val(val), m_recursive(recursive) {}

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

    private:
        SetProp() {}

        void set_recursive(SceneObject *obj) const;

    protected:
        virtual void save(SerializationInterface &ar) const;

        virtual void load(DeserializationInterface &ar);

    private:
        ObjectID m_target;

        PropKey m_key;

        Any m_val;

        bool m_recursive;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 115


#endif // PEEKABOT_SET_PROP_HH_INCLUDED
