/*
 * Copyright Staffan Gimåker 2008-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_SET_ROTATION_HH_INCLUDED
#define PEEKABOT_SET_ROTATION_HH_INCLUDED


#include <stdexcept>
#include "../Types.hh"
#include "../Action.hh"


namespace peekabot
{
    class SetRotation : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        SetRotation(
            ObjectID target,
            float yaw,
            float pitch,
            float roll,
            CoordinateSystem coord_sys) throw();

        virtual ~SetRotation() throw();

        virtual Action *clone() const;

        virtual void execute(
            ServerExecutionContext *context)
            const throw(std::exception);

    private:
        SetRotation() throw();

        SetRotation(const SetRotation &action) throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        ObjectID m_target;

        float m_yaw, m_pitch, m_roll;

        CoordinateSystem m_coord_sys;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 87


#endif // PEEKABOT_SET_ROTATION_HH_INCLUDED
