/*
 * Copyright Staffan Gimåker 2007-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_SET_VERTICES_HH_INCLUDED
#define PEEKABOT_SET_VERTICES_HH_INCLUDED


#include <vector>
#include <Eigen/Core>

#include "../Types.hh"
#include "../Action.hh"


namespace peekabot
{
    /**
     * \brief Action used to set or add coordinates of a vertex-based object.
     */
    class SetVertices : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        SetVertices(
            ObjectID target,
            const std::vector<Eigen::Vector3f> &vertices,
            bool add_to_existing = false) throw();

        virtual ~SetVertices() throw();

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

    private:
        SetVertices() throw();

        SetVertices(const SetVertices &x) throw();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        ObjectID m_target;
        std::vector<Eigen::Vector3f> m_vertices;
        bool m_add_to_existing;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 32


#endif // PEEKABOT_SET_VERTICES_HH_INCLUDED
