/*
 * Copyright Staffan Gimåker 2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_TRANSLATE_HH_INCLUDED
#define PEEKABOT_TRANSLATE_HH_INCLUDED


#include "../Types.hh"
#include "../Action.hh"


namespace peekabot
{
    /**
     * \brief Translate an object about an arbitrary pivot using an arbitrary
     * rotational axis.
     */
    class Translate : public Action
    {
        PEEKABOT_SERIALIZABLE

    public:
        Translate(
            ObjectID target,
            float x, float y, float z,
            CoordinateSystem coord_sys);

        virtual Action *clone() const;

        virtual void execute(ServerExecutionContext *context) const;

    private:
        Translate();

    protected:
        void save(SerializationInterface &ar) const;

        void load(DeserializationInterface &ar);

    private:
        ObjectID m_target;
        float m_x, m_y, m_z;
        CoordinateSystem m_coord_sys;
    };
}


// PEEKABOT_REGISTER_SERIALIZABLE 104


#endif // PEEKABOT_TRANSLATE_HH_INCLUDED
