/*
 * Copyright Staffan Gimåker 2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_CLIENT_ACTION_RECORDER_HH_INCLUDED
#define PEEKABOT_CLIENT_ACTION_RECORDER_HH_INCLUDED


#include <queue>
#include <fstream>
#include <boost/thread.hpp>
#include <boost/thread/recursive_mutex.hpp>
#include <boost/thread/condition.hpp>
#include <boost/date_time/posix_time/posix_time.hpp>

#include "Transport.hh"


namespace peekabot
{
    class PbarWriter;

    namespace client
    {
        class ActionRecorder : public Transport
        {
        public:
            ActionRecorder(
                boost::shared_ptr<ClientImpl> client,
                const std::string &filename);

            virtual ~ActionRecorder();

            virtual void dispatch_action(boost::shared_ptr<Action> action);

            virtual void flush();

        private:
            typedef std::pair<
                boost::posix_time::ptime,
                boost::shared_ptr<Action> > TimestampedAction;

            void run();

        private:
            boost::thread *m_thread;

            volatile bool m_stop_signal;

            mutable boost::recursive_mutex m_queue_mutex;

            boost::condition m_queue_cond;

            boost::condition m_flush_cond;

            std::queue<TimestampedAction> m_queue;

            std::ofstream m_ofs;

            const boost::posix_time::ptime m_t0;

            PbarWriter *m_writer;
        };
    }
}


#endif // PEEKABOT_CLIENT_ACTION_RECORDER_HH_INCLUDED
