/*
 * Copyright Staffan Gimåker 2006-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_CLIENT_CLIENT_EXECUTION_CONTEXT_HH_INCLUDED
#define PEEKABOT_CLIENT_CLIENT_EXECUTION_CONTEXT_HH_INCLUDED


#include <string>
#include <boost/cstdint.hpp>

#include "../Any.hh"
#include "Status.hh"


namespace peekabot
{
    namespace client
    {
        class ClientImpl;

        class ClientExecutionContext
        {
        protected:
            ClientImpl *m_client;

        public:
            ClientExecutionContext(ClientImpl *client) throw();

            void report_action_status(
                boost::uint32_t request_id,
                OperationOutcome outcome,
                const std::string &error_msg) throw();

            void report_action_result(
                boost::uint32_t request_id,
                const Any &result) throw();
        };
    }
}


#endif // PEEKABOT_CLIENT_CLIENT_EXECUTION_CONTEXT_HH_INCLUDED
