/*
 * Copyright Staffan Gimåker 2008-2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_CLIENT_EXCEPTIONS_HH_INCLUDED
#define PEEKABOT_CLIENT_EXCEPTIONS_HH_INCLUDED


#include <stdexcept>

#include "../Visibility.hh"


namespace peekabot
{
    namespace client
    {
        class PEEKABOT_API AuthenticationFailed : public std::runtime_error
        {
        public:
            AuthenticationFailed(const std::string &what)
                : std::runtime_error(what) {}
        };

        class PEEKABOT_API HostResolveFailed : public std::runtime_error
        {
        public:
            HostResolveFailed(const std::string &what)
                : std::runtime_error(what) {}
        };

        class PEEKABOT_API ConnectionRefused : public std::runtime_error
        {
        public:
            ConnectionRefused(const std::string &what)
                : std::runtime_error(what) {}
        };

        class PEEKABOT_API AlreadyConnected : public std::runtime_error
        {
        public:
            AlreadyConnected(const std::string &what)
                : std::runtime_error(what) {}
        };
    }
}


#endif // PEEKABOT_CLIENT_EXCEPTIONS_HH_INCLUDED
