/*
 * Copyright Staffan Gimåker 2007-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include "OperationResult.hh"


using namespace peekabot;
using namespace peekabot::client;


OperationResult::OperationResult()
    : OperationStatus(),
      m_result_is_set(false)
{
}


OperationResult::~OperationResult()
{
}


void OperationResult::set_result(const Any &result)
{
    boost::mutex::scoped_lock lock(m_result_mutex);

    m_result = result;
    m_result_is_set = true;
}


Any OperationResult::get_result() const
{
    OperationOutcome outcome = get_outcome();
    if( outcome == OPERATION_SUCCEEDED && m_result_is_set )
    {
        boost::mutex::scoped_lock lock(m_result_mutex);

        return m_result;
    }
    else if( outcome == OPERATION_FAILED )
        throw std::logic_error(
            "The operation failed, thus no result is available");
    else
        throw std::logic_error(
            "The requested result is not yet available");
}
