/*
 * Copyright Staffan Gimåker 2007-2008, 2010.
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include <cassert>

#include "OperationStatus.hh"


using namespace peekabot;
using namespace peekabot::client;



OperationStatus::OperationStatus()
    : m_outcome(OUTCOME_PENDING),
      m_client_was_disconnected(false)
{
}


OperationStatus::~OperationStatus()
{
}


OperationOutcome OperationStatus::get_outcome() const
{
    boost::mutex::scoped_lock lock(m_mutex);

    return m_outcome;
}


void OperationStatus::set_outcome(
    OperationOutcome outcome,
    const std::string &error_msg)
{
    boost::mutex::scoped_lock lock(m_mutex);

    assert( outcome != OUTCOME_PENDING );

    m_outcome = outcome;
    m_error_msg = error_msg;

    m_outcome_cond.notify_all();
}


std::string OperationStatus::get_error_msg() const
{
    boost::mutex::scoped_lock lock(m_mutex);

    return m_error_msg;
}


bool OperationStatus::wait_until_completed() const
{
    boost::mutex::scoped_lock lock(m_mutex);

    if( m_outcome == OUTCOME_PENDING && !m_client_was_disconnected )
    {
        m_outcome_cond.wait(lock);
    }

    return m_client_was_disconnected;
}


void OperationStatus::wake() const
{
    m_outcome_cond.notify_all();
}


void OperationStatus::client_disconnected()
{
    {
        boost::mutex::scoped_lock lock(m_mutex);
        m_client_was_disconnected = true;
    }

    wake();
}
