/*
 * Copyright Staffan Gimåker 2009
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include "Recording.hh"
#include "RecordingImpl.hh"


using namespace peekabot;
using namespace peekabot::client;


Recording::Recording(boost::shared_ptr<RecordingImpl> impl)
    : m_impl(impl)
{
}


void Recording::play()
{
    m_impl->play();
}


void Recording::pause()
{
    m_impl->pause();
}


bool Recording::is_paused() const
{
    return m_impl->is_paused();
}


bool Recording::is_finished() const
{
    return m_impl->is_finished();
}


void Recording::step(size_t n)
{
    m_impl->step(n);
}


void Recording::step(const boost::posix_time::time_duration &td)
{
    m_impl->step(td);
}


void Recording::set_playback_speed(double factor)
{
    m_impl->set_playback_speed(factor);
}


double Recording::get_playback_speed() const
{
    return m_impl->get_playback_speed();
}


boost::posix_time::time_duration Recording::elapsed() const
{
    return m_impl->elapsed();
}


boost::posix_time::time_duration Recording::duration() const
{
    return m_impl->duration();
}
