/*
 * Copyright Staffan Gimåker 2006-2008, 2010.
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include <cassert>

#include "Status.hh"


using namespace peekabot;
using namespace peekabot::client;




namespace
{
    const std::string UNUSED_ERROR_MSG = "The Status/Result object is unused!";
}



Status::Status()
{
}


Status::Status(boost::shared_ptr<OperationStatus> status)
    : m_status(status)
{
}


Status::~Status()
{
}


Status &Status::operator=(
    boost::shared_ptr<OperationStatus> status)
{
    m_status = status;

    return *this;
}


OperationOutcome Status::get_outcome() const
{
    if( m_status.get() == 0 )
        throw std::logic_error(UNUSED_ERROR_MSG);

    return m_status->get_outcome();
}


bool Status::has_completed() const
{
    if( m_status.get() == 0 )
        throw std::logic_error(UNUSED_ERROR_MSG);

    return ( m_status->get_outcome() != OUTCOME_PENDING );
}


bool Status::succeeded() const
{
    if( wait_until_completed() )
        return false;

    return ( m_status->get_outcome() == OPERATION_SUCCEEDED );
}


bool Status::failed() const
{
    if( wait_until_completed() )
        return true;

    return ( m_status->get_outcome() == OPERATION_FAILED );
}


bool Status::wait_until_completed() const
{
    if( m_status.get() == 0 )
        throw std::logic_error(UNUSED_ERROR_MSG);

    return m_status->wait_until_completed();
}


std::string Status::get_error_message() const
{
    if( m_status.get() == 0 )
        throw std::logic_error(UNUSED_ERROR_MSG);

    return m_status->get_error_msg();
}
