/*
 * Copyright Staffan Gimåker 2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_CLIENT_TRANSPORT_HH_INCLUDED
#define PEEKABOT_CLIENT_TRANSPORT_HH_INCLUDED


#include <boost/shared_ptr.hpp>
#include <boost/weak_ptr.hpp>


namespace peekabot
{
    class Action;

    namespace client
    {
        class ClientImpl;

        class Transport
        {
        public:
            Transport(boost::shared_ptr<ClientImpl> client)
                : m_client(client) {}

            virtual ~Transport() {}

            virtual void dispatch_action(boost::shared_ptr<Action> action) = 0;

            virtual void flush() = 0;

        protected:
            inline boost::shared_ptr<ClientImpl> client()
            {
                return m_client.lock();
            }

            inline const boost::shared_ptr<ClientImpl> client() const
            {
                return m_client.lock();
            }

            /**
             * \brief This method must be called if the transport
             * spontaneously disconnects, e.g. because of dead TCP-connection.
             */
            void disconnected();

            void execute_action(boost::shared_ptr<Action> action);

        private:
            boost::weak_ptr<ClientImpl> m_client;
        };
    }
}


#endif // PEEKABOT_CLIENT_TRANSPORT_HH_INCLUDED
