/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include "LabelProxy.hh"
#include "../PeekabotClient.hh"
#include "../../PropKeys.hh"
#include "../../ObjectTypes.hh"

#include "../../actions/AddObject.hh"
#include "../../actions/Assign.hh"
#include "../../actions/SetProp.hh"


using namespace peekabot;
using namespace peekabot::client;


//
// ------------------ LabelProxyBase implementation -------------------
//


LabelProxyBase::LabelProxyBase()
{
}


LabelProxyBase::LabelProxyBase(const LabelProxyBase &p)
    : ObjectProxyBase(p),
      ScalableProxyBase(p)
{
}

//

DelayedDispatch LabelProxyBase::set_text(const std::string &text)
{
    return DelayedDispatch(
        get_client_impl(),
        new SetProp(get_object_id(), LABEL_TEXT_PROP, text));
}

DelayedDispatch LabelProxyBase::set_alignment(TextAlignment alignment)
{
    return DelayedDispatch(
        get_client_impl(),
        new SetProp(get_object_id(), LABEL_ALIGNMENT_PROP, alignment));
}


//
// ------------------ LabelProxy implementation -------------------
//


LabelProxy::LabelProxy()
{
}


LabelProxy::LabelProxy(const LabelProxyBase &p)
    : ObjectProxyBase(p),
      LabelProxyBase(p)
{
}


LabelProxy &LabelProxy::operator=(const LabelProxy &p)
{
    return *this = (LabelProxyBase &)p;
}


LabelProxy &LabelProxy::operator=(const LabelProxyBase &p)
{
    unchecked_assign(unchecked_get_client_impl(p), get_pseudonym(p));
    return *this;
}


DelayedDispatch LabelProxy::assign(const ObjectProxyBase &p)
{
    unchecked_assign(get_client_impl(p), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new Assign(PathIdentifier(get_object_id(p)),
                   get_object_id(), LABEL_OBJECT));
}


DelayedDispatch LabelProxy::assign(
    PeekabotClient &client, const std::string &path)
{
    unchecked_assign(get_client_impl(client), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(), new Assign(
            PathIdentifier(path), get_object_id(), LABEL_OBJECT));
}


DelayedDispatch LabelProxy::assign(
    const ObjectProxyBase &parent, 
    const std::string &rel_path)
{
    unchecked_assign(get_client_impl(parent), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(), new Assign(
            PathIdentifier(get_object_id(parent), rel_path),
            get_object_id(), LABEL_OBJECT));
}


DelayedDispatch LabelProxy::add(
    PeekabotClient &client,
    const std::string &path,
    NameConflictPolicy conflict_policy)
{
    unchecked_assign(get_client_impl(client), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new AddObject(PathIdentifier(path),
                      conflict_policy, get_object_id(), LABEL_OBJECT));
}


DelayedDispatch LabelProxy::add(
    const ObjectProxyBase &parent, 
    const std::string &name,
    NameConflictPolicy conflict_policy)
{
    unchecked_assign(get_client_impl(parent), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new AddObject(PathIdentifier(get_object_id(parent), name),
                      conflict_policy, get_object_id(), LABEL_OBJECT));
}
