/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include "LineCloudProxy.hh"
#include "../PeekabotClient.hh"
#include "../../ObjectTypes.hh"

#include "../../actions/AddObject.hh"
#include "../../actions/Assign.hh"


using namespace peekabot;
using namespace peekabot::client;


//
// ------------------ LineCloudProxyBase implementation -------------------
//


LineCloudProxyBase::LineCloudProxyBase()
{
}


LineCloudProxyBase::LineCloudProxyBase(const LineCloudProxyBase &p)
    : ObjectProxyBase(p),
      ScalableProxyBase(p),
      VertexBasedProxyBase(p),
      LineBasedProxyBase(p)
{
}

//

DelayedDispatch LineCloudProxyBase::add_line(
    float x1, float y1, float z1,
    float x2, float y2, float z2)
{
    VertexSet vs;
    vs.add_vertex(x1,y1,z1);
    vs.add_vertex(x2,y2,z2);
    return add_vertices(vs);
}


//
// ------------------ LineCloudProxy implementation -------------------
//


LineCloudProxy::LineCloudProxy()
{
}


LineCloudProxy::LineCloudProxy(const LineCloudProxyBase &p)
    : ObjectProxyBase(p),
      LineCloudProxyBase(p)
{
}


LineCloudProxy &LineCloudProxy::operator=(const LineCloudProxy &p)
{
    return *this = (LineCloudProxyBase &)p;
}


LineCloudProxy &LineCloudProxy::operator=(const LineCloudProxyBase &p)
{
    unchecked_assign(unchecked_get_client_impl(p), get_pseudonym(p));
    return *this;
}


DelayedDispatch LineCloudProxy::assign(const ObjectProxyBase &p)
{
    unchecked_assign(get_client_impl(p), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new Assign(PathIdentifier(get_object_id(p)),
                   get_object_id(), LINE_CLOUD_OBJECT));
}


DelayedDispatch LineCloudProxy::assign(
    PeekabotClient &client, const std::string &path)
{
    unchecked_assign(get_client_impl(client), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new Assign(PathIdentifier(path), get_object_id(), LINE_CLOUD_OBJECT));
}


DelayedDispatch LineCloudProxy::assign(
    const ObjectProxyBase &parent, 
    const std::string &rel_path)
{
    unchecked_assign(get_client_impl(parent), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(), new Assign(
            PathIdentifier(get_object_id(parent), rel_path),
            get_object_id(), LINE_CLOUD_OBJECT));
}


DelayedDispatch LineCloudProxy::add(
    PeekabotClient &client,
    const std::string &path,
    NameConflictPolicy conflict_policy)
{
    unchecked_assign(get_client_impl(client), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new AddObject(PathIdentifier(path), conflict_policy,
                      get_object_id(), LINE_CLOUD_OBJECT));
}


DelayedDispatch LineCloudProxy::add(
    const ObjectProxyBase &parent, 
    const std::string &name,
    NameConflictPolicy conflict_policy)
{
    unchecked_assign(get_client_impl(parent), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new AddObject(PathIdentifier(get_object_id(parent), name),
                      conflict_policy, get_object_id(), LINE_CLOUD_OBJECT));
}
