/*
 * Copyright Staffan Gimåker 2008-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include "ModelProxy.hh"
#include "../PeekabotClient.hh"
#include "../../ObjectTypes.hh"

#include "../../actions/AddObject.hh"
#include "../../actions/Assign.hh"


using namespace peekabot;
using namespace peekabot::client;


//
// ------------------ ModelProxyBase implementation -------------------
//


ModelProxyBase::ModelProxyBase()
{
}


ModelProxyBase::ModelProxyBase(const ModelProxyBase &p)
    : ObjectProxyBase(p),
      ScalableProxyBase(p)
{
}


//
// ------------------ ModelProxy implementation -------------------
//


ModelProxy::ModelProxy()
{
}


ModelProxy::ModelProxy(const ModelProxyBase &p)
    : ObjectProxyBase(p),
      ModelProxyBase(p)
{
}


ModelProxy &ModelProxy::operator=(const ModelProxy &p)
{
    return *this = (ModelProxyBase &)p;
}


ModelProxy &ModelProxy::operator=(const ModelProxyBase &p)
{
    unchecked_assign(unchecked_get_client_impl(p), get_pseudonym(p));
    return *this;
}


DelayedDispatch ModelProxy::assign(const ObjectProxyBase &p)
{
    unchecked_assign(get_client_impl(p), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new Assign(PathIdentifier(get_object_id(p)),
                   get_object_id(), MODEL_OBJECT));
}


DelayedDispatch ModelProxy::assign(
    PeekabotClient &client, const std::string &path)
{
    unchecked_assign(get_client_impl(client), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(), new Assign(
            PathIdentifier(path), get_object_id(), MODEL_OBJECT));
}


DelayedDispatch ModelProxy::assign(
    const ObjectProxyBase &parent, 
    const std::string &rel_path)
{
    unchecked_assign(get_client_impl(parent), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(), new Assign(
            PathIdentifier(get_object_id(parent), rel_path),
            get_object_id(), MODEL_OBJECT));
}


DelayedDispatch ModelProxy::add(
    PeekabotClient &client,
    const std::string &path,
    const std::string &filename,
    NameConflictPolicy conflict_policy)
{
    unchecked_assign(get_client_impl(client), allocate_pseudonym());

    AddObject::Args args;
    args.push_back(Any(filename));

    return DelayedDispatch(
        get_client_impl(),
        new AddObject(PathIdentifier(path), conflict_policy,
                      get_object_id(), MODEL_OBJECT, args));
}


DelayedDispatch ModelProxy::add(
    const ObjectProxyBase &parent, 
    const std::string &name,
    const std::string &filename,
    NameConflictPolicy conflict_policy)
{
    unchecked_assign(get_client_impl(parent), allocate_pseudonym());

    AddObject::Args args;
    args.push_back(Any(filename));

    return DelayedDispatch(
        get_client_impl(),
        new AddObject(PathIdentifier(get_object_id(parent), name),
                      conflict_policy, get_object_id(), MODEL_OBJECT, args));
}
