/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_CLIENT_POLYLINE_PROXY_HH_INCLUDED
#define PEEKABOT_CLIENT_POLYLINE_PROXY_HH_INCLUDED


#include "ScalableProxy.hh"
#include "VertexBasedProxy.hh"
#include "LineBasedProxy.hh"


namespace peekabot
{
    namespace client
    {
        /**
         * \brief Base class for PolylineProxy.
         */
        class PEEKABOT_API PolylineProxyBase :
            public ScalableProxyBase,
            public VertexBasedProxyBase,
            public LineBasedProxyBase
        {
        public:
            PolylineProxyBase();

            PolylineProxyBase(const PolylineProxyBase &p);
        };


        /**
         * \brief Proxy class used to add and manipulate polylines.
         *
         * The line chain is manipulated through the methods
         * exposed by VertexBasedProxyBase, e.g. set_vertices(), add_vertices()
         * and clear_vertices().
         */
        class PEEKABOT_API PolylineProxy : public PolylineProxyBase
        {
        public:
            PolylineProxy();

            PolylineProxy(const PolylineProxyBase &p);

            PolylineProxy &operator=(const PolylineProxy &p);

            PolylineProxy &operator=(const PolylineProxyBase &p);

            /**
             * \copydoc ScalableProxy::assign(const ObjectProxyBase&)
             */
            DelayedDispatch assign(const ObjectProxyBase &p);

            /**
             * \copydoc ObjectProxy::assign(PeekabotClient&,const std::string&)
             */
            DelayedDispatch assign(
                PeekabotClient &client,
                const std::string &path);

            /**
             * \copydoc
             * ObjectProxy::assign(const ObjectProxyBase&,const std::string&)
             */
            DelayedDispatch assign(
                const ObjectProxyBase &parent,
                const std::string &rel_path);

            /**
             * \brief Add a polyline to the scene.
             *
             * Adds an empty polyline to the scene at the given path and
             * assigns the proxy to refer to it. If an object already exists at
             * the given path the outcome is governed by \a conflict_policy.
             *
             * \param path The path where the object will be added, including
             * the name of the object.
             * \param conflict_policy Determines how name conflicts are handled.
             */
            DelayedDispatch add(
                PeekabotClient &client,
                const std::string &path,
                NameConflictPolicy conflict_policy = AUTO_ENUMERATE_ON_CONFLICT);

            /**
             * \brief Add a polyline to the scene.
             *
             * Adds an empty polyline with the given name under the
             * object referred to by \a parent and assigns the proxy to refer
             * to it. If an object already exists at the given path the outcome
             * is governed by \a conflict_policy.
             *
             * \param parent The parent under which the object will be added.
             * \param name The name to assign to the created object.
             * \param conflict_policy Determines how name conflicts are handled.
             */
            DelayedDispatch add(
                const ObjectProxyBase &parent,
                const std::string &name,
                NameConflictPolicy conflict_policy = AUTO_ENUMERATE_ON_CONFLICT);
        };
    }
}


#endif // PEEKABOT_CLIENT_POLYLINE_PROXY_HH_INCLUDED
