/*
 * Copyright Staffan Gimåker 2009-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#include "SliderProxy.hh"
#include "../PeekabotClient.hh"
#include "../../ObjectTypes.hh"

#include "../../actions/AddObject.hh"
#include "../../actions/Assign.hh"
#include "../../actions/SetHingeAxis.hh"


using namespace peekabot;
using namespace peekabot::client;


//
// ------------------ SliderProxyBase implementation -------------------
//


SliderProxyBase::SliderProxyBase()
{
}


SliderProxyBase::SliderProxyBase(const SliderProxyBase &p)
    : JointProxyBase(p)
{
}


DelayedDispatch SliderProxyBase::set_axis(
    float x, float y, float z,
    CoordinateSystem coord_sys)
{
    return DelayedDispatch(
        get_client_impl(),
        new SetHingeAxis(get_object_id(), x, y, z, coord_sys));
}


//
// ------------------ SliderProxy implementation -------------------
//


SliderProxy::SliderProxy()
{
}


SliderProxy::SliderProxy(const SliderProxyBase &p)
    : SliderProxyBase(p)
{
}


SliderProxy &SliderProxy::operator=(const SliderProxy &p)
{
    return *this = (SliderProxyBase &)p;
}


SliderProxy &SliderProxy::operator=(const SliderProxyBase &p)
{
    unchecked_assign(unchecked_get_client_impl(p), get_pseudonym(p));
    return *this;
}


DelayedDispatch SliderProxy::assign(const ObjectProxyBase &p)
{
    unchecked_assign(get_client_impl(p), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new Assign(PathIdentifier(get_object_id(p)),
                   get_object_id(), SLIDER_OBJECT));
}


DelayedDispatch SliderProxy::assign(
    PeekabotClient &client, const std::string &path)
{
    unchecked_assign(get_client_impl(client), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new Assign(PathIdentifier(path), get_object_id(), SLIDER_OBJECT));
}


DelayedDispatch SliderProxy::assign(
    const ObjectProxyBase &parent,
    const std::string &rel_path)
{
    unchecked_assign(get_client_impl(parent), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new Assign(
            PathIdentifier(get_object_id(parent), rel_path),
            get_object_id(), SLIDER_OBJECT));
}


DelayedDispatch SliderProxy::add(
    PeekabotClient &client,
    const std::string &path,
    NameConflictPolicy conflict_policy)
{
    unchecked_assign(get_client_impl(client), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new AddObject(PathIdentifier(path), conflict_policy,
                      get_object_id(), SLIDER_OBJECT));
}


DelayedDispatch SliderProxy::add(
    const ObjectProxyBase &parent,
    const std::string &name,
    NameConflictPolicy conflict_policy)
{
    unchecked_assign(get_client_impl(parent), allocate_pseudonym());

    return DelayedDispatch(
        get_client_impl(),
        new AddObject(PathIdentifier(get_object_id(parent), name),
                      conflict_policy, get_object_id(), SLIDER_OBJECT));
}
