/*
 * Copyright Staffan Gimåker 2009.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

#ifndef PEEKABOT_CLIENT_SLIDER_PROXY_HH_INCLUDED
#define PEEKABOT_CLIENT_SLIDER_PROXY_HH_INCLUDED


#include "JointProxy.hh"


namespace peekabot
{
    namespace client
    {
        /**
         * \brief Base class for SliderProxy.
         */
        class PEEKABOT_API SliderProxyBase : public JointProxyBase
        {
        public:
            SliderProxyBase();

            SliderProxyBase(const SliderProxyBase &p);

            /**
             * \brief Set the slider's displacement axis.
             *
             * \param coord_sys The coordinate system in which the axis
             * is given.
             */
            DelayedDispatch set_axis(
                float x, float y, float z,
                CoordinateSystem coord_sys = PARENT_COORDINATES);
        };


        /**
         * \brief Proxy class used manipulate sliders.
         */
        class PEEKABOT_API SliderProxy : public SliderProxyBase
        {
        public:
            SliderProxy();

            SliderProxy(const SliderProxyBase &p);

            SliderProxy &operator=(const SliderProxy &p);

            SliderProxy &operator=(const SliderProxyBase &p);

            /**
             * \copydoc ScalableProxy::assign(const ObjectProxyBase&)
             */
            DelayedDispatch assign(const ObjectProxyBase &p);

            /**
             * \copydoc ObjectProxy::assign(PeekabotClient&,const std::string&)
             */
            DelayedDispatch assign(
                PeekabotClient &client,
                const std::string &path);

            /**
             * \copydoc
             * ObjectProxy::assign(const ObjectProxyBase&,const std::string&)
             */
            DelayedDispatch assign(
                const ObjectProxyBase &parent,
                const std::string &rel_path);

            /**
             * \brief Add a slider joint.
             *
             * If an object already exists at the given path the outcome is
             * governed by \a conflict_policy.
             *
             * \param path The path where the object will be added, including
             * the name of the object.
             * \param conflict_policy Determines how name conflicts are handled.
             */
            DelayedDispatch add(
                PeekabotClient &client,
                const std::string &path,
                NameConflictPolicy conflict_policy = AUTO_ENUMERATE_ON_CONFLICT);

            /**
             * \brief Add a slider joint.
             *
             * If an object already exists at the given path the outcome is
             * governed by \a conflict_policy.
             *
             * \param parent The parent under which the object will be added.
             * \param name The name to assign to the created object.
             * \param conflict_policy Determines how name conflicts are handled.
             */
            DelayedDispatch add(
                const ObjectProxyBase &parent,
                const std::string &name,
                NameConflictPolicy conflict_policy = AUTO_ENUMERATE_ON_CONFLICT);
        };
    }
}


#endif // PEEKABOT_CLIENT_SLIDER_PROXY_HH_INCLUDED
