/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_GUI_FRAME_LAYOUT_CONTROLLER_HH_INCLUDED
#define PEEKABOT_GUI_FRAME_LAYOUT_CONTROLLER_HH_INCLUDED


#include <set>
#include <gtkmm.h>
#include <boost/signals2.hpp>


namespace peekabot
{
    namespace gui
    {
        class Gui;
        class Frame;

        class FrameLayoutController
        {
            struct Node;

        public:
            FrameLayoutController(Gui &gui);

            ~FrameLayoutController();

            inline Gui &get_gui() { return m_gui; }

            inline const Gui &get_gui() const { return m_gui; }

            enum SplitDirection
            {
                VSPLIT,
                HSPLIT
            };

            void set_initial_frame(Frame *frame);

            void split(
                const Frame *frame, SplitDirection dir, Frame *new_frame);

            void collapse(const Frame *frame, bool collapse_other);

            /// \name GUI-side signals
            /// @{

            typedef boost::signals2::signal<void (Frame *)> FrameAddedSignal;

            typedef boost::signals2::signal<void (Frame *)> FrameRemovedSignal;

            inline FrameAddedSignal &frame_added_signal()
            {
                return m_frame_added_signal;
            }

            inline FrameRemovedSignal &frame_removed_signal()
            {
                return m_frame_removed_signal;
            }

            /// @}

        private:
            Node *find_node(const Frame *frame);

            Node *find_node_impl(const Frame *frame, Node *node);

            void collapse_child(Node *node, bool second);

        private:
            Gui &m_gui;

            Node *m_root;


            FrameAddedSignal m_frame_added_signal;
            FrameRemovedSignal m_frame_removed_signal;
        };
    }
}


#endif // PEEKABOT_GUI_FRAME_LAYOUT_CONTROLLER_HH_INCLUDED
