/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_GUI_LOG_VIEW_CONTROLLERHH_INCLUDED
#define PEEKABOT_GUI_LOG_VIEW_CONTROLLERHH_INCLUDED


#include "../Subscriber.hh"

#include <gtkmm.h>


namespace peekabot
{
    namespace gui
    {
        class Gui;

        class LogViewController : private Subscriber
        {
        public:
            LogViewController(Gui &gui);

            virtual ~LogViewController();

        private:
            // Note! Not necessarily executed in the GUI thread
            virtual void handle_message(const Message &message) throw();

            void handle_message_handler(Message message);

            void on_toggle_log();

        private:
            Gui &m_gui;

            Gtk::TextView *m_view;

            Gtk::ScrolledWindow *m_log_window;

            Gtk::VPaned *m_log_paned;

            Glib::RefPtr<Gtk::TextBuffer> m_buffer;

            Glib::RefPtr<Gtk::TextBuffer::Mark> m_eof_mark;

            Glib::RefPtr<Gtk::ToggleAction> m_toggle_log_action;
        };
    }
}


#endif // PEEKABOT_GUI_LOG_VIEW_CONTROLLERHH_INCLUDED
