/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_GUI_MTOW_PROP_MEDIATOR_HH_INCLUDED
#define PEEKABOT_GUI_MTOW_PROP_MEDIATOR_HH_INCLUDED


#include "../Types.hh"
#include "PropMediator.hh"

#include <gtkmm.h>
#include <boost/cstdint.hpp>
#include <Eigen/Core>
#include <Eigen/Geometry>


namespace peekabot
{
    class SceneObject;
    class MtowPropAdapter;
    class ServerData;

    namespace gui
    {
        class Gui;

        class MtowPropMediator : public PropMediator
        {
        public:
            MtowPropMediator(
                PropInspectorController &pi, SceneObject *obj,
                MtowPropAdapter *prop, PropKey prop_key);

            // Must be executed in the server thread
            virtual void destroy();

        private:
            // Executed in the GUI thread
            void create_widgets(std::string prop_name);

            // Executed in the GUI thread
            void destroy_widgets();

            // Executed in the server thread
            void on_prop_set();

            // Executed in the GUI thread
            void update_values(
                Eigen::Transform3f mtow, Eigen::Transform3f mtop);

            // Executed in the GUI thread
            void update_widgets();

            // Executed in the GUI thread
            void on_xyz_set();

            // Executed in the GUI thread
            void on_rpy_set();

            // Executed in the GUI thread
            void on_csys_changed();

            static void set_position(
                ServerData &sd, ObjectID object_id,
                Eigen::Vector3f pos, bool world_coords);

            static void set_rpy(
                ServerData &sd, ObjectID object_id,
                float roll, float pitch, float yaw, bool world_coords);

        private:
            // Access from the server thread only
            SceneObject * const m_obj;

            // Access from the server thread only
            MtowPropAdapter * const m_prop;

            const ObjectID m_object_id;

            const PropKey m_prop_key;

            // Access from the GUI thread only
            int m_n_updates_queued;

            // Access from the GUI thread only
            Eigen::Transform3f m_mtow, m_mtop;
            bool m_world_coords;

            // Access from the GUI thread only
            Gtk::SpinButton *m_xyz[3];
            Gtk::SpinButton *m_rpy[3];
            Gtk::Label *m_xyz_lbl;
            Gtk::Label *m_rpy_lbl;
            Gtk::HBox *m_xyz_hbox;
            Gtk::HBox *m_rpy_hbox;
            Gtk::ComboBoxText *m_csys_box;

            sigc::connection m_xyz_set_conn[3];
            sigc::connection m_rpy_set_conn[3];
        };
    }
}


#endif // PEEKABOT_GUI_MTOW_PROP_MEDIATOR_HH_INCLUDED
