/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_GUI_PBAR_PLAYER_CONTROLLER_HH_INCLUDED
#define PEEKABOT_GUI_PBAR_PLAYER_CONTROLLER_HH_INCLUDED


#include <gtkmm.h>
#include <boost/shared_ptr.hpp>


namespace peekabot
{
    class PbarPlayer;
    class ServerData;
    class Action;

    namespace gui
    {
        class Gui;

        class PbarPlayerController
        {
            class ActionSourceData;

        public:
            PbarPlayerController(Gui &gui);

        private:
            void setup_actions();

            void setup_widgets();

            /// \name GUI slots
            /// @{

            void on_open_pbar();

            void on_open_pbar_response(int response);

            void on_toggle_toolbar();

            void on_play_toggled();

            void on_playback_speed_changed();

            void on_time_advanced(double t);

            void on_finished();

            void on_reload();

            void on_close();

            void on_step_clicked(
                Gtk::EntryIconPosition, const GdkEventButton *);

            void on_timestep_clicked(
                Gtk::EntryIconPosition, const GdkEventButton *);

            /// @}

            void load_recording(const std::string &filename);

            void unload_recording();

            void execute_action(
                ServerData &sd, boost::shared_ptr<Action> action);

            // Run in the PbarPlayer thread
            void dispatch_action(boost::shared_ptr<Action> action);

        private:
            Gui &m_gui;

            PbarPlayer *m_player;
            ActionSourceData *m_action_source_data;

            // true if the loaded recording has been started (play or step
            // pressed once or more). undefined if no recording is loaded.
            bool m_started;
            std::string m_filename;

            // Actions

            Glib::RefPtr<Gtk::Action> m_open_action;

            Glib::RefPtr<Gtk::Action> m_close_action;

            Glib::RefPtr<Gtk::Action> m_reload_action;

            Glib::RefPtr<Gtk::ToggleAction> m_toggle_toolbar_action;

            Glib::RefPtr<Gtk::ToggleAction> m_play_action;

            // Widgets

            Gtk::Toolbar *m_toolbar;

            Gtk::FileChooserDialog *m_open_pbar_dialog;

            Gtk::SpinButton *m_step_spinbutton;

            Gtk::SpinButton *m_timestep_spinbutton;

            Gtk::SpinButton *m_speed_spinbutton;

            Gtk::HScale *m_timeline;

            //

            sigc::connection m_play_conn;
        };
    }
}


#endif // PEEKABOT_GUI_PBAR_PLAYER_CONTROLLER_HH_INCLUDED
