/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_GUI_PROP_INSPECTOR_CONTROLLER_HH_INCLUDED
#define PEEKABOT_GUI_PROP_INSPECTOR_CONTROLLER_HH_INCLUDED


#include "../Types.hh"
#include "../Any.hh"

#include <set>
#include <gtkmm.h>
#include <boost/shared_ptr.hpp>
#include <boost/function.hpp>


namespace peekabot
{
    class ServerData;
    class SceneObject;

    namespace gui
    {
        class Gui;
        class PropMediator;

        class PropInspectorController
        {
        public:
            PropInspectorController(Gui &gui);

            ~PropInspectorController();

            void add_prop_widgets(Gtk::Widget *lbl, Gtk::Widget *w);

            void erase_prop_widgets(Gtk::Widget *lbl, Gtk::Widget *w);

            inline Gui &get_gui() { return m_gui; }

            inline const Gui &get_gui() const { return m_gui; }

        private:
            void show_prop_widgets(ObjectType type);

            void hide_prop_widgets();

            /// \name Methods executed in the server thread
            /// @{

            void ss_on_selection_changed();

            void add_prop_mediators(SceneObject *obj);

            void clear_prop_mediators();

            /// @}

        private:
            Gui &m_gui;

            Gtk::Table *m_prop_table;
            Gtk::Image *m_prop_img;
            Gtk::Label *m_prop_lbl;

            std::set<PropMediator *> m_ss_prop_mediators;

            // Access only from the GUI thread
            unsigned int m_prop_rows;
        };
    }
}


#endif // PEEKABOT_GUI_PROP_INSPECTOR_CONTROLLER_HH_INCLUDED
