/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "PropMediator.hh"
#include "PropInspectorController.hh"
#include "Gui.hh"
#include "../Server.hh"
#include "../SceneObject.hh"
#include "../SceneTree.hh"

#include <cassert>


using namespace peekabot;
using namespace peekabot::gui;


PropMediator::PropMediator(PropInspectorController &pi)
    : m_prop_inspector_controller(pi)
{
}


PropMediator::~PropMediator()
{
}


void PropMediator::post(const boost::function<void ()> &handler)
{
    m_prop_inspector_controller.get_gui().post(handler);
}


void PropMediator::server_post(
    const boost::function<void (ServerData &)> &handler)
{
    m_prop_inspector_controller.get_gui().server_post(handler);
}


PropInspectorController &PropMediator::get_prop_inspector_controller()
{
    return m_prop_inspector_controller;
}


const PropInspectorController &
PropMediator::get_prop_inspector_controller() const
{
    return m_prop_inspector_controller;
}


void PropMediator::ss_set_prop(
    ServerData &sd, ObjectID object_id, PropKey prop_key, Any val)
{
    SceneObject *obj = sd.m_scene->get_object(object_id);
    if( obj )
        obj->set_prop_value(prop_key, val);
}


void PropMediator::add_prop_widgets(Gtk::Widget *lbl, Gtk::Widget *widget)
{
    m_prop_inspector_controller.add_prop_widgets(lbl, widget);
}


void PropMediator::erase_prop_widgets(Gtk::Widget *lbl, Gtk::Widget *widget)
{
    m_prop_inspector_controller.erase_prop_widgets(lbl, widget);
}
