/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_GUI_PROP_MEDIATOR_FACTORY_HH_INCLUDED
#define PEEKABOT_GUI_PROP_MEDIATOR_FACTORY_HH_INCLUDED


#include "../Types.hh"
#include "../PropVisitor.hh"


namespace peekabot
{
    class SceneObject;

    namespace gui
    {
        class PropInspectorController;
        class PropMediator;

        /**
         * \brief Given a prop and its parent object, the PropMediatorFactory
         * creates a suitable PropMediator for it.
         */
        class PropMediatorFactory : private PropVisitor
        {
        public:
            PropMediatorFactory(PropInspectorController &pi);

            PropMediator *create_mediator(SceneObject *obj, PropKey prop_key);

        private:
            virtual void visit(BoolPropBase *prop);

            virtual void visit(FloatPropBase *prop);

            virtual void visit(StringPropBase *prop);

            virtual void visit(EnumPropBase *prop);

            virtual void visit(ColorPropBase *prop);

            virtual void visit(Uint32PropBase *prop);

            virtual void visit(Vector3PropBase *prop);

            virtual void visit(LayerPropAdapter *prop);

            virtual void visit(MtowPropAdapter *prop);

        private:
            PropInspectorController &m_pi;

            SceneObject *m_obj;

            PropKey m_prop_key;

            PropMediator *m_mediator;
        };
    }
}


#endif // PEEKABOT_GUI_PROP_MEDIATOR_FACTORY_HH_INCLUDED
