/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_GUI_ROTATE_TOOL_HH_INCLUDED
#define PEEKABOT_GUI_ROTATE_TOOL_HH_INCLUDED


#include "../Types.hh"
#include "Tool.hh"

#include <set>


namespace peekabot
{
    class ServerData;

    namespace gui
    {
        class Gui;

        class RotateTool : public Tool
        {
        public:
            RotateTool(Gui &gui);

            virtual void activate();

            virtual void deactivate();

            virtual void button_release(
                SceneViewFrame *sf, const GdkEventButton *event);

            virtual void mouse_drag(
                SceneViewFrame *sf, const GdkEventMotion *event,
                double dx, double dy);

            virtual void key_release(
                SceneViewFrame *sf, const GdkEventKey *event);

        private:
            void on_axis_toggled();

            void on_system_changed();

            void on_pivot_changed();

            /// \name Methods executed in the server thread
            /// @{

            void rotate(
                ServerData &sd, std::set<ObjectID> selection,
                ObjectID cam_id, CoordinateSystem system,
                RotationCenterpoint pivot, Axis axes,
                double dx, double dy);

            /// @}

        private:
            Gui &m_gui;

            Gtk::Viewport *m_options_viewport;

            Gtk::RadioButton *m_axis_button[3];

            Gtk::Table *m_table;

            Gtk::ComboBoxText m_system_combobox;

            Gtk::ComboBoxText m_pivot_combobox;
        };
    }
}


#endif // PEEKABOT_GUI_ROTATE_TOOL_HH_INCLUDED
