/*
 * Copyright Staffan Gimåker 2010-2011.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_GUI_TOOL_CONTROLLER_HH_INCLUDED
#define PEEKABOT_GUI_TOOL_CONTROLLER_HH_INCLUDED


#include <gtkmm.h>
#include <boost/scoped_ptr.hpp>


namespace peekabot
{
    namespace gui
    {
        class Gui;
        class Tool;
        class NavigateTool;
        class MoveTool;
        class RotateTool;

        class ToolController
        {
        public:
            ToolController(Gui &gui);

            ~ToolController();

            Tool &get_active_tool();

            void activate_nav_tool();

            void activate_move_tool();

            void activate_rotate_tool();

        private:
            void on_tool_changed(
                const Glib::RefPtr<Gtk::RadioAction> &current);

        private:
            Gui &m_gui;

            Glib::RefPtr<Gtk::RadioAction> m_nav_tool_action;
            Glib::RefPtr<Gtk::RadioAction> m_move_tool_action;
            Glib::RefPtr<Gtk::RadioAction> m_rotate_tool_action;

            boost::scoped_ptr<NavigateTool> m_nav_tool;
            boost::scoped_ptr<MoveTool> m_move_tool;
            boost::scoped_ptr<RotateTool> m_rotate_tool;
            Tool *m_active_tool;
        };
    }
}


#endif // PEEKABOT_GUI_TOOL_CONTROLLER_HH_INCLUDED
