/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_GUI_VECTOR3_PROP_MEDIATOR_HH_INCLUDED
#define PEEKABOT_GUI_VECTOR3_PROP_MEDIATOR_HH_INCLUDED


#include "../Types.hh"
#include "PropMediator.hh"

#include <gtkmm.h>
#include <Eigen/Core>


namespace peekabot
{
    class SceneObject;
    class Vector3PropBase;

    namespace gui
    {
        class Vector3PropMediator : public PropMediator
        {
        public:
            Vector3PropMediator(
                PropInspectorController &pi, SceneObject *obj,
                Vector3PropBase *prop, PropKey prop_key);

            // Must be executed in the server thread
            virtual void destroy();

        private:
            // Executed in the GUI thread
            void create_widget(
                std::string prop_name,
                Eigen::Vector3f val, bool read_only);

            // Executed in the GUI thread
            void destroy_widget();

            // Executed in the server thread
            void on_prop_set();

            // Executed in the GUI thread
            void update_widget(Eigen::Vector3f val);

            // Executed in the GUI thread
            void on_widget_set();

        private:
            // Access from the server thread only
            SceneObject * const m_obj;

            // Access from the server thread only
            Vector3PropBase * const m_prop;

            const ObjectID m_object_id;

            const PropKey m_prop_key;

            // Access from the GUI thread only
            int m_n_updates_queued;

            // Access from the GUI thread only
            Gtk::SpinButton *m_xyz[3];
            Gtk::HBox *m_hbox;
            Gtk::Label *m_lbl;

            sigc::connection m_xyz_set_conn[3];
        };
    }
}


#endif // PEEKABOT_GUI_VECTOR3_PROP_MEDIATOR_HH_INCLUDED
