/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_GUI_WORK_QUEUE_HH_INCLUDED
#define PEEKABOT_GUI_WORK_QUEUE_HH_INCLUDED


#include <queue>
#include <glibmm/dispatcher.h>
#include <boost/function.hpp>
#include <boost/utility.hpp>
#include <boost/thread/recursive_mutex.hpp>
#include <boost/date_time/posix_time/posix_time.hpp>


namespace peekabot
{
    namespace gui
    {
        class WorkQueue : public boost::noncopyable
        {
        public:
            WorkQueue();

            ~WorkQueue();

            void post(const boost::function<void ()> &handler);

            void set_processing_freq(float freq);

            float get_processing_freq() const;

            void set_pre_processing_callback(
                const boost::function<void ()> &fun);

            void set_post_processing_callback(
                const boost::function<void ()> &fun);

            void start();

        private:
            void on_dispatch();

            void process();

        private:
            std::size_t m_posts_idx;

            std::queue<boost::function<void ()> > m_posts[2];

            Glib::Dispatcher m_dispatcher;
            sigc::connection m_dispatcher_conn;

            bool m_is_dispatching;

            boost::posix_time::time_duration m_process_interval;

            // Only accessed in the GUI thread, thus access is not governed by
            // the mutex
            boost::posix_time::ptime m_last_process;

            mutable boost::recursive_mutex m_mutex;

            boost::function<void ()> m_pre_process_fun;
            boost::function<void ()> m_post_process_fun;
        };
    }
}


#endif // PEEKABOT_GUI_WORK_QUEUE_HH_INCLUDED
