/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_BOOL_PROP_BASE_HH_INCLUDED
#define PEEKABOT_BOOL_PROP_BASE_HH_INCLUDED


#include "Prop.hh"
#include "PropVisitor.hh"


namespace peekabot
{
    class BoolPropBase : public Prop
    {
    public:
        virtual void accept(PropVisitor &visitor)
        {
            visitor.visit(this);
        }

        virtual bool display_as_toggle_button(
            std::string &true_str, std::string &false_str) const
        {
            true_str = "Yes";
            false_str = "No";
            return true;
        }
    };
}


#endif // PEEKABOT_BOOL_PROP_BASE_HH_INCLUDED
