/*
 * Copyright Staffan Gimåker 2008.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "CullableEntity.hh"


using namespace peekabot;
using namespace peekabot::renderer;


CullableEntity::CullableEntity()
{
    set_bounding_sphere(BoundingSphere(Eigen::Vector3f(0,0,0), 0));
}


CullableEntity::CullableEntity(const BoundingSphere &bs)
{
    set_bounding_sphere(bs);
}


void CullableEntity::set_bounding_sphere(const Eigen::Vector3f &v, float r)
{
    set_bounding_sphere(BoundingSphere(v,r));
}


void CullableEntity::set_bounding_sphere(const BoundingSphere &bs)
{
    m_bs_local = bs;
    recalc_world_bs();

    m_on_local_bv_set(this);
}


void CullableEntity::recalc_world_bs()
{
    // Re-calcuate the position of the bounding sphere in global coordinates
    double s = std::max(get_x_scale(), std::max(get_y_scale(), get_z_scale()));

    m_bs_world = BoundingSphere(
        get_transformation() * m_bs_local.get_pos(),
        s*m_bs_local.get_radius() );

    m_on_world_bv_set(this);
}


void CullableEntity::on_transformation_set()
{
    recalc_world_bs();
}
