/*
 * Copyright Staffan Gimåker 2007-2008, 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_DEVICE_HH_INCLUDED
#define PEEKABOT_RENDERER_DEVICE_HH_INCLUDED


#include <GL/glew.h>
#include "../Types.hh"
#include "../MessageHub.hh"


namespace peekabot
{
    namespace renderer
    {
        class Device
        {
        public:       
            /*static void set_color(const RGBColor &color) throw();

              static void set_color(const RGBColor &color, float opacity) throw();

              static void set_line_width(float line_width) throw();

              static void set_point_size(float point_size) throw();*/

            static void toggle_culling(bool enable) throw()
            {
                if( enable )
                    glEnable(GL_CULL_FACE);
                else
                    glDisable(GL_CULL_FACE);
            }


            static void toggle_lighting(bool enable) throw()
            {
                if( enable )
                    glEnable(GL_LIGHTING);
                else
                    glDisable(GL_LIGHTING);
            }


            static void toggle_stencil_test(bool enable) throw()
            {
                if( enable )
                    glEnable(GL_STENCIL_TEST);
                else
                    glDisable(GL_STENCIL_TEST);
            }

            static void toggle_depth_mask(bool enable) throw()
            {
                glDepthMask(enable ? GL_TRUE:GL_FALSE);
            }

            static void toggle_color_material(bool enable) throw()
            {
                if( enable )
                    glEnable(GL_COLOR_MATERIAL);
                else
                    glDisable(GL_COLOR_MATERIAL);
            }

            static void toggle_multisampling(bool enable) throw()
            {
                if( enable )
                    glEnable(GL_MULTISAMPLE);
                else
                    glDisable(GL_MULTISAMPLE);
            }

            static void toggle_point_smoothing(bool enable) throw()
            {
                if( enable )
                    glEnable(GL_POINT_SMOOTH);
                else
                    glDisable(GL_POINT_SMOOTH);
            }

            static void toggle_front_face_culling(bool enable) throw()
            {
                if( enable )
                    glCullFace(GL_FRONT);
                else
                    glCullFace(GL_BACK);
            }

            static bool has_vbo_support() throw()
            {
                return GLEW_ARB_vertex_buffer_object;
            }
        };


#define CHECK_GL_ERRORS()                                           \
        {                                                           \
            GLenum err_code = glGetError();                         \
            if( err_code != GL_NO_ERROR )                           \
            {                                                       \
                TheMessageHub::instance().publish(                  \
                    DEBUG_MESSAGE, "OpenGL error: %s (%s:%u)",      \
                    gluErrorString(err_code), __FILE__, __LINE__);  \
            }                                                       \
        }

    }
}


#endif // PEEKABOT_RENDERER_DEVICE_HH_INCLUDED
