/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __PEEKABOT_RENDERER_INDEX_BASED_HH
#define __PEEKABOT_RENDERER_INDEX_BASED_HH


#include <vector>
#include "../Types.hh"


namespace peekabot
{
    namespace renderer
    {
        class IndexBased
        {
        public:
            typedef std::vector<uint32_t> Indices;

            virtual ~IndexBased() {}

            virtual void set_indices(const Indices &indices) = 0;

            virtual void add_indices(const Indices &indices) = 0;

            virtual void get_indices(Indices &indices) const = 0;
        };
    }
}


#endif // __PEEKABOT_RENDERER_INDEX_BASED_HH
