/*
 * Copyright Staffan Gimåker 2007-2009.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_RENDERER_MESH_FACTORY_HH_INCLUDED
#define PEEKABOT_RENDERER_MESH_FACTORY_HH_INCLUDED


#include <vector>
#include <Eigen/Core>
#include <boost/cstdint.hpp>


namespace peekabot
{
    namespace renderer
    {

        class Mesh;


        class MeshFactory
        {
        public:
            static Mesh *get_disc_mesh(int segments, float r) throw();

            static Mesh *get_cylinder_mesh(
                int segments, float r, float h) throw();

            static Mesh *get_icosphere_mesh(int subdiv, float r) throw();

            static Mesh *get_circle_mesh(int segments, float r) throw();

            static Mesh *get_cone_mesh(
                float r, float h,
                size_t segments, size_t lat_subdiv) throw();

        private:
            static void subdivide(
                boost::uint32_t v0_idx, boost::uint32_t v1_idx, boost::uint32_t v2_idx,
                std::vector<Eigen::Vector3f> &vertices,
                std::vector<boost::uint32_t> &indices,
                int depth) throw();
        };

    }
}


#endif // PEEKABOT_RENDERER_MESH_FACTORY_HH_INCLUDED
